/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.utils;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * @author liulongbing
 * @since 2024/5/13
 */
public class SpUtils {

    public static final String KEY_DB_MODIFY_TIME = "td_modify_time";
    public static final String KEY_CLIENT_VALUE = "td_client_value";

    private SharedPreferences sp;
    private static SpUtils instance;

    private SpUtils() {
    }

    public void init(Context context) {
        sp = context.getSharedPreferences("td_strategy_sp", Context.MODE_PRIVATE);
    }

    public static SpUtils getInstance() {
        if (instance == null) {
            instance = new SpUtils();
        }
        return instance;
    }

    public void putString(String key, String value) {
        if (sp == null) return;
        sp.edit().putString(key, value).apply();
    }

    public String getString(String key, String defValue) {
        if (sp == null) return defValue;
        return sp.getString(key, defValue);
    }

    public void putLong(String key, long value) {
        if (sp == null) return;
        sp.edit().putLong(key, value).apply();
    }

    public long getLong(String key, long defValue) {
        if (sp == null) return defValue;
        return sp.getLong(key, defValue);
    }

    public void putBoolean(String key, boolean value) {
        if (sp == null) return;
        sp.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key, boolean defValue) {
        if (sp == null) return defValue;
        return sp.getBoolean(key, defValue);
    }

}
