/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;

/**
 * @author liulongbing
 * @since 2024/10/15
 */
public class JsonUtils {
    public static void mergeJSONObject(final JSONObject source, final JSONObject dest) throws JSONException {
        Iterator<String> sourceIterator = source.keys();
        while (sourceIterator.hasNext()) {
            String key = sourceIterator.next();
            Object value = source.get(key);
            if (value instanceof JSONArray) {
                dest.put(key, formatJSONArray(( JSONArray ) value));
            } else if (value instanceof JSONObject) {
                dest.put(key, formatJSONObject(( JSONObject ) value));
            } else {
                dest.put(key, value);
            }
        }
    }

    private static JSONObject formatJSONObject(JSONObject jsonObject) {
        JSONObject result = new JSONObject();
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = null;
            try {
                value = jsonObject.get(key);
                if (value instanceof JSONArray) {
                    result.put(key, formatJSONArray(( JSONArray ) value));
                } else if (value instanceof JSONObject) {
                    result.put(key, formatJSONObject(( JSONObject ) value));
                } else {
                    result.put(key, value);
                }
            } catch (JSONException exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    private static JSONArray formatJSONArray(JSONArray jsonArr) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArr.length(); i++) {
            Object value = jsonArr.opt(i);
            if (value != null) {
                if (value instanceof JSONArray) {
                    result.put(formatJSONArray(( JSONArray ) value));
                } else if (value instanceof JSONObject) {
                    JSONObject newObject = formatJSONObject(( JSONObject ) value);
                    result.put(newObject);
                } else {
                    result.put(value);
                }
            }

        }
        return result;
    }

}
