/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.task;

import org.json.JSONException;
import org.json.JSONObject;

import cn.thinkingdata.strategy.utils.JsonUtils;
import cn.thinkingdata.strategy.utils.SpUtils;

/**
 * @author liulongbing
 * @since 2024/10/15
 */
public class TDClientValueManager {

    private JSONObject mClientValueParams;

    private static TDClientValueManager instance = null;

    private TDClientValueManager() {

    }

    public static TDClientValueManager getInstance() {
        if (instance == null) {
            instance = new TDClientValueManager();
        }
        return instance;
    }

    public void addClientParams(JSONObject params) {
        if (params == null) return;
        loadLocalClientParams();
        try {
            JsonUtils.mergeJSONObject(params, mClientValueParams);
            SpUtils.getInstance().putString(SpUtils.KEY_CLIENT_VALUE, mClientValueParams.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void removeClientParam(String key) {
        if (key == null) return;
        loadLocalClientParams();
        mClientValueParams.remove(key);
        SpUtils.getInstance().putString(SpUtils.KEY_CLIENT_VALUE, mClientValueParams.toString());
    }

    private void loadLocalClientParams() {
        if (mClientValueParams == null) {
            try {
                mClientValueParams = new JSONObject(SpUtils.getInstance().getString(SpUtils.KEY_CLIENT_VALUE, "{}"));
            } catch (JSONException e) {
                mClientValueParams = new JSONObject();
            }
        }
    }

    public Object get(String key) {
        if (key == null) return null;
        loadLocalClientParams();
        return mClientValueParams.opt(key);
    }


}
