/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.task;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * <  >.
 *
 * @author liulongbing
 * @create 2024/3/8
 * @since
 */
public class StrategyTaskManager {

    private volatile static StrategyTaskManager instance = null;
    private final ExecutorService executor;

    private StrategyTaskManager() {
        executor = new ThreadPoolExecutor(1, 1,
                0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingDeque<Runnable>(), new ThreadFactory() {
            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TDStrategy.TaskExecuteThread");
            }
        });
    }

    public static StrategyTaskManager getInstance() {
        if (instance == null) {
            synchronized (StrategyTaskManager.class) {
                if (instance == null) {
                    instance = new StrategyTaskManager();
                }
            }
        }
        return instance;
    }

    public void addTask(Runnable runnable) {
        try {
            executor.execute(runnable);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
