/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.storage.db;

import android.text.TextUtils;

import java.util.Objects;

/**
 * @author liulongbing
 * @since 2024/3/13
 */
public class FrequencyLimitInfo {
    public String appId;
    public String userId;
    public String taskId;
    public long timeStamp;

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FrequencyLimitInfo) {
            FrequencyLimitInfo info = ( FrequencyLimitInfo ) obj;
            return TextUtils.equals(this.appId, info.appId) && TextUtils.equals(this.userId, info.userId) && TextUtils.equals(this.taskId, info.taskId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, userId, taskId);
    }

}
