/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.support.composite;

import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.rules.api.Rule;
import cn.thinkingdata.strategy.rules.core.BasicRule;
import cn.thinkingdata.strategy.rules.core.RuleProxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * Base class representing a composite rule composed of a set of rules.
 * 
 * <strong>This class is not thread-safe.
 * Sub-classes are inherently not thread-safe.</strong>
 *
 * @author Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 */
public abstract class CompositeRule extends BasicRule {

    /**
     * The set of composing rules.
     */
//    protected Set<Rule> rules;
//    protected final Map<Object, Rule> proxyRules;

    protected List<Rule> rules;

    /**
     * Create a new {@link CompositeRule}.
     */
    public CompositeRule() {
        this(Rule.DEFAULT_NAME, Rule.DEFAULT_DESCRIPTION, Rule.DEFAULT_PRIORITY);
    }

    /**
     * Create a new {@link CompositeRule}.
     *
     * @param name rule name
     */
    public CompositeRule(final String name) {
        this(name, Rule.DEFAULT_DESCRIPTION, Rule.DEFAULT_PRIORITY);
    }

    /**
     * Create a new {@link CompositeRule}.
     *
     * @param name rule name
     * @param description rule description
     */
    public CompositeRule(final String name, final String description) {
        this(name, description, Rule.DEFAULT_PRIORITY);
    }

    /**
     * Create a new {@link CompositeRule}.
     *
     * @param name rule name
     * @param description rule description
     * @param priority rule priority
     */
    public CompositeRule(final String name, final String description, final int priority) {
        super(name, description, priority);
//        rules = new TreeSet<>();
//        proxyRules = new HashMap<>();
        rules = new ArrayList<>();
    }

    @Override
    public abstract boolean evaluate(Facts facts);

    @Override
    public abstract void execute(Facts facts) throws Exception;

    /**
     * Add a rule to the composite rule.
     * @param rule the rule to add
     */
    public void addRule(final Object rule) {
        Rule proxy = RuleProxy.asRule(rule);
        rules.add(proxy);
        //proxyRules.put(rule, proxy);
    }

    /**
     * Remove a rule from the composite rule.
     * @param rule the rule to remove
     */
    public void removeRule(final Object rule) {
//        Rule proxy = proxyRules.get(rule);
//        if (proxy != null) {
//            rules.remove(proxy);
//        }
    }

}
