/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.factory;

import org.json.JSONObject;

import cn.thinkingdata.strategy.core.trigger.AbstractTriggerRule;
import cn.thinkingdata.strategy.rules.filters.analytic.EventCountRule;
import cn.thinkingdata.strategy.rules.filters.contition.*;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * <  >.
 *
 * @author liulongbing
 * @since 2024/3/12
 */
public class RuleFactory {
    public static Object createFilterRule(JSONObject fitItem, double zoneOffset) {
        if (fitItem == null) return null;
        String symbol = fitItem.optString("calcuSymbol");
        switch (symbol) {
            case StrategyConstants.C00:
                return new EQRule(fitItem);
            case StrategyConstants.C01:
                return new UN_EQRule(fitItem);
            case StrategyConstants.C02:
                return new LTRule(fitItem);
            case StrategyConstants.C020:
                return new LTERule(fitItem, zoneOffset);
            case StrategyConstants.C03:
                return new GTRule(fitItem);
            case StrategyConstants.C030:
                return new GTERule(fitItem, zoneOffset);
            case StrategyConstants.C04:
                return new NOT_NULLRule(fitItem);
            case StrategyConstants.C05:
                return new NULLRule(fitItem);
            case StrategyConstants.C06:
                return new RANGERule(fitItem, zoneOffset);
            case StrategyConstants.C07:
                return new INCLUDERule(fitItem);
            case StrategyConstants.C08:
                return new UN_INCLUDERule(fitItem);
            case StrategyConstants.C09:
                return new BOOLEAN_TRUERule(fitItem);
            case StrategyConstants.C10:
                return new BOOLEAN_FALSERule(fitItem);
            case StrategyConstants.C11:
                return new REGULAR_MATCHRule(fitItem);
            case StrategyConstants.C12:
                return new UN_REGULAR_MATCHRule(fitItem);
            case StrategyConstants.C13:
                return new RELATIVE_CURRENT_TIMERule(fitItem);
            case StrategyConstants.C14:
                return new RELATIVE_EVENT_TIMERule(fitItem);
            case StrategyConstants.C15:
                return new ARRAY_INCLUDE_ITEMRule(fitItem);
            case StrategyConstants.C16:
                return new ARRAY_UN_INCLUDE_ITEMRule(fitItem);
            case StrategyConstants.C17:
                return new ARRAY_ITEM_POSRule(fitItem, zoneOffset);
            case StrategyConstants.C18:
                return new ARRAY_NULLRule(fitItem);
            case StrategyConstants.C19:
                return new ARRAY_NON_NULLRule(fitItem);
            case StrategyConstants.C22:
                return new ARRAY_ROW_EXIST_INCLUDERule(fitItem, zoneOffset);
            case StrategyConstants.C23:
                return new ARRAY_ROW_NONE_EXISTRule(fitItem, zoneOffset);
            case StrategyConstants.C24:
                return new ARRAY_ROW_ALL_INCLUDERule(fitItem, zoneOffset);
            default:
                return null;
        }
    }

    public static Object createAnalyticsRule(JSONObject analyticItem, AbstractTriggerRule triggerRule) {
        if (analyticItem == null) return null;
        JSONObject taPropQuota = analyticItem.optJSONObject("taPropQuota");
        if (null == taPropQuota) return null;
        String analysis = taPropQuota.optString("analysis");
        switch (analysis) {
            case StrategyConstants.A200:
                return new EventCountRule(analyticItem, triggerRule);
            default:
                return null;
        }
    }
}
