/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.util.regex.Pattern;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C12, description = "正则不匹配")
public class UN_REGULAR_MATCHRule extends PropertiesRule {
    public UN_REGULAR_MATCHRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (ftv.size() > 0) {
            if (StrategyConstants.STR_TYPE.equals(columnType)) {
                String v = value.toString();
                String tValue = ftv.get(0).toString();
                Pattern pattern = Pattern.compile(
                        tValue, Pattern.CASE_INSENSITIVE);
                return !pattern.matcher(v).find();
            }
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
