/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C08, description = "不包括")
public class UN_INCLUDERule extends PropertiesRule {

    public UN_INCLUDERule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        if (StrategyConstants.STR_TYPE.equals(columnType)) {
            String v = value.toString();
            boolean isFind = false;
            for (Object o : ftv) {
                String tValue = o.toString();
                if (v.contains(tValue)) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }

}
