/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;
import android.text.TextUtils;
import org.json.JSONObject;
import java.math.BigDecimal;
import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;
/**
 *
 * @author liulongbing
 * @since  2024/3/12
 */
@Rule(name = StrategyConstants.C01, description = "不等于")
public class UN_EQRule extends PropertiesRule {

    public UN_EQRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (StrategyConstants.STR_TYPE.equals(columnType)) {
            String v = value.toString();
            boolean isFind = false;
            for (Object o : ftv) {
                String t = o.toString();
                if (TextUtils.equals(v, t)) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        } else if (StrategyConstants.INTEGER_TYPE.equals(columnType)) {
            int v = Integer.parseInt(value.toString());
            boolean isFind = false;
            for (Object o : ftv) {
                int i = Integer.parseInt(o.toString());
                if (v == i) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        } else if (StrategyConstants.BIGINT_TYPE.equals(columnType)) {
            long v = Long.parseLong(value.toString());
            boolean isFind = false;
            for (Object o : ftv) {
                long l = Long.parseLong(o.toString());
                if (v == l) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        } else if (StrategyConstants.DOUBLE_TYPE.equals(columnType)) {
            double v = Double.parseDouble(value.toString());
            boolean isFind = false;
            for (Object o : ftv) {
                double d = Double.parseDouble(o.toString());
                if (v == d) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        } else if (StrategyConstants.DECIMAL_TYPE.equals(columnType)) {
            BigDecimal v = ( BigDecimal ) value;
            boolean isFind = false;
            for (Object o : ftv) {
                BigDecimal b = BigDecimal.valueOf(Double.parseDouble(o.toString()));
                if (v.compareTo(b) == 0) {
                    isFind = true;
                    break;
                }
            }
            return !isFind;
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
