/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.util.Calendar;
import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.AnalyticUtils;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/19
 */
@Rule(name = StrategyConstants.C13, description = "相对当前时间")
public class RELATIVE_CURRENT_TIMERule extends PropertiesRule {

    public RELATIVE_CURRENT_TIMERule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }


    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (StrategyConstants.DATE_TYPE.equals(columnType)) {
            String v = value.toString();
            Object zOffset = facts.get(StrategyConstants.EVENT_ZONE_OFFSET);
            long timeStamp = CommonUtils.getTimeStampForObj(v,zOffset);
            long targetTimeStamp = getTargetTimeStamp(facts);
            if (ftv.size() == 1) {
                int dayBefore = Integer.parseInt(ftv.get(0).toString());
                long beforeTimeStamp = targetTimeStamp - ( long ) dayBefore * 24 * 60 * 60 * 1000;
                return timeStamp <= beforeTimeStamp;
            } else if (ftv.size() == 2) {
                int dayBefore = Integer.parseInt(ftv.get(0).toString());
                int dayAfter = Integer.parseInt(ftv.get(1).toString());
                long start = targetTimeStamp + ( long ) dayBefore * 24 * 60 * 60 * 1000;
                long end = targetTimeStamp + ( long ) (dayAfter + 1) * 24 * 60 * 60 * 1000;
                return timeStamp >= start && timeStamp < end;
            }
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }

    private long getTargetTimeStamp(Facts facts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(AnalyticUtils.getCurrentTimeStamp());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTimeInMillis();
    }

}
