/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.math.BigDecimal;

import cn.thinkingdata.core.utils.TimeUtil;
import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * <  >.
 *
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C06, description = "区间")
public class RANGERule extends PropertiesRule {

    private final double zoneOffset;

    public RANGERule(JSONObject ruleJson, double zoneOffset) {
        super(ruleJson);
        this.zoneOffset = zoneOffset;
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (ftv.size() >= 2) {
            if (StrategyConstants.INTEGER_TYPE.equals(columnType)) {
                int v = Integer.parseInt(value.toString());
                int tValue1 = Integer.parseInt(ftv.get(0).toString());
                int tValue2 = Integer.parseInt(ftv.get(1).toString());
                return v >= tValue1 && v <= tValue2;
            } else if (StrategyConstants.BIGINT_TYPE.equals(columnType)) {
                long v = Long.parseLong(value.toString());
                long tValue1 = Long.parseLong(ftv.get(0).toString());
                long tValue2 = Long.parseLong(ftv.get(1).toString());
                return v >= tValue1 && v <= tValue2;
            } else if (StrategyConstants.DOUBLE_TYPE.equals(columnType)) {
                double v = Double.parseDouble(value.toString());
                double tValue1 = Double.parseDouble(ftv.get(0).toString());
                double tValue2 = Double.parseDouble(ftv.get(1).toString());
                return v >= tValue1 && v <= tValue2;
            } else if (StrategyConstants.DECIMAL_TYPE.equals(columnType)) {
                BigDecimal v = ( BigDecimal ) value;
                BigDecimal tValue1 = BigDecimal.valueOf(Double.parseDouble(ftv.get(0).toString()));
                BigDecimal tValue2 = BigDecimal.valueOf(Double.parseDouble(ftv.get(1).toString()));
                return v.compareTo(tValue1) >= 0 && v.compareTo(tValue2) <= 0;
            } else if (StrategyConstants.DATE_TYPE.equals(columnType)) {
                String v = value.toString();
                Object eventTimeZoneOffset = facts.get(StrategyConstants.EVENT_ZONE_OFFSET);
                long timeStamp = CommonUtils.getTimeStampForObj(v,eventTimeZoneOffset);
                long tValue1 = TimeUtil.getFormatDate(ftv.get(0).toString(), StrategyConstants.TIME_PATTERN, zoneOffset).getTime();
                long tValue2 = TimeUtil.getFormatDate(ftv.get(1).toString(), StrategyConstants.TIME_PATTERN, zoneOffset).getTime();
                if (timeStamp != 0 && tValue1 != 0 && tValue2 != 0) {
                    return timeStamp >= tValue1 && timeStamp <= tValue2;
                }
            }
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
