/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.TDStrategyLog;

/**
 * @author liulongbing
 * @since 2024/3/11
 */
public abstract class PropertiesRule {

    protected String columnName;
    protected String columnType;
    protected List<Object> ftv;
    protected String symbol;
    protected JSONObject ruleJson;

    public PropertiesRule(JSONObject ruleJson) {
        try {
            if (ruleJson == null) {
                this.ruleJson = new JSONObject();
            } else {
                this.ruleJson = ruleJson;
            }
            this.columnName = this.ruleJson.optString("columnName");
            this.columnType = this.ruleJson.optString("columnType");
            this.symbol = this.ruleJson.optString("calcuSymbol");
            ftv = new ArrayList<>();
            JSONArray fArray = this.ruleJson.optJSONArray("ftv");
            if (fArray != null) {
                for (int i = 0; i < fArray.length(); i++) {
                    if (fArray.get(i) != null) {
                        ftv.add(fArray.get(i));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isCondition(Facts facts) {
        try {
            Object value = facts.get(columnName);
            if (value == null) {
                boolean isPreset = isPresetProperties(columnName);
                TDStrategyLog.i("CalcuSymbol：" + symbol + " Value is null and ColumnName：" + columnName + " is Preset: " + isPreset);
                return isPreset;
            }
            boolean isWhen = executeWhen(value, facts);
            TDStrategyLog.i("CalcuSymbol：" + symbol + " ColumnName：" + columnName + " Value：" + value + " Ftv:" + ftv.toString() + " Result：" + isWhen);
            return isWhen;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public abstract boolean executeWhen(Object value, Facts facts);

    protected boolean isPresetProperties(String columnName) {
        return null != columnName && columnName.contains("#");
    }

}
