/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import android.text.TextUtils;

import org.json.JSONObject;

import java.math.BigDecimal;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;
import cn.thinkingdata.strategy.utils.TDStrategyLog;

/**
 * <  >.
 *
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C05, description = "无值")
public class NULLRule extends PropertiesRule {
    public NULLRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        try {
            Object value = facts.get(columnName);
            boolean isWhen = value == null;
            TDStrategyLog.i("CalcuSymbol：" + symbol + " ColumnName：" + columnName + " Value：" + value + " Ftv:" + ftv.toString() + " Result：" + isWhen);
            return isWhen;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
