/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.math.BigDecimal;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C03, description = "大于")
public class GTRule extends PropertiesRule {
    public GTRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (ftv.size() > 0) {
            if (StrategyConstants.INTEGER_TYPE.equals(columnType)) {
                int v = Integer.parseInt(value.toString());
                int tValue = Integer.parseInt(ftv.get(0).toString());
                return v > tValue;
            } else if (StrategyConstants.BIGINT_TYPE.equals(columnType)) {
                long v = Long.parseLong(value.toString());
                long tValue = Long.parseLong(ftv.get(0).toString());
                return v > tValue;
            } else if (StrategyConstants.DOUBLE_TYPE.equals(columnType)) {
                double v = Double.parseDouble(value.toString());
                double tValue = Double.parseDouble(ftv.get(0).toString());
                return v > tValue;
            } else if (StrategyConstants.DECIMAL_TYPE.equals(columnType)) {
                BigDecimal v = ( BigDecimal ) value;
                BigDecimal tValue = BigDecimal.valueOf(Double.parseDouble(ftv.get(0).toString()));
                return v.compareTo(tValue) > 0;
            }
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
