/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import android.text.TextUtils;

import org.json.JSONObject;

import java.math.BigDecimal;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/11
 */
@Rule(name = StrategyConstants.C00, description = "等于")
public class EQRule extends PropertiesRule {

    public EQRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        if (StrategyConstants.STR_TYPE.equals(columnType) || StrategyConstants.DATE_TYPE.equals(columnType)
                || StrategyConstants.ARRAY_VARCHAR_TYPE.equals(columnType)) {
            String v = value.toString();
            for (Object o : ftv) {
                String t = o.toString();
                if (TextUtils.equals(v, t)) {
                    return true;
                }
            }
        } else if (StrategyConstants.INTEGER_TYPE.equals(columnType)) {
            int v = Integer.parseInt(value.toString());
            for (Object o : ftv) {
                int i = Integer.parseInt(o.toString());
                if (v == i) {
                    return true;
                }
            }
        } else if (StrategyConstants.BIGINT_TYPE.equals(columnType)) {
            long v = Long.parseLong(value.toString());
            for (Object o : ftv) {
                long l = Long.parseLong(o.toString());
                if (v == l) {
                    return true;
                }
            }
        } else if (StrategyConstants.DOUBLE_TYPE.equals(columnType)) {
            double v = Double.parseDouble(value.toString());
            for (Object o : ftv) {
                double d = Double.parseDouble(o.toString());
                if (v == d) {
                    return true;
                }
            }
        } else if (StrategyConstants.DECIMAL_TYPE.equals(columnType)) {
            BigDecimal v = ( BigDecimal ) value;
            for (Object o : ftv) {
                BigDecimal b = BigDecimal.valueOf(Double.parseDouble(o.toString()));
                if (v.compareTo(b) == 0) {
                    return true;
                }
            }
        } else if (StrategyConstants.BOOLEAN_TYPE.equals(columnType)) {
            boolean v = Boolean.parseBoolean(value.toString());
            for (Object o : ftv) {
                boolean b = Boolean.parseBoolean(o.toString());
                if (v == b) {
                    return true;
                }
            }
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }

}
