/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 *
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C09, description = "为真")
public class BOOLEAN_TRUERule extends PropertiesRule {

    public BOOLEAN_TRUERule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (StrategyConstants.BOOLEAN_TYPE.equals(columnType)) {
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
