/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/3/12
 */
@Rule(name = StrategyConstants.C10, description = "为假")
public class BOOLEAN_FALSERule extends PropertiesRule {
    public BOOLEAN_FALSERule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value,Facts facts) {
        if (StrategyConstants.BOOLEAN_TYPE.equals(columnType)) {
            boolean v = Boolean.parseBoolean(value.toString());
            return !v;
        }
        return false;
    }

    @Action
    public void then(Facts facts) {

    }
}
