/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.util.List;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/5/8
 */
@Rule(name = StrategyConstants.C16, description = "不存在元素")
public class ARRAY_UN_INCLUDE_ITEMRule extends ARRAY_INCLUDE_ITEMRule {

    public ARRAY_UN_INCLUDE_ITEMRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    protected boolean isArrayVarCondition(List<String> strList) {
        for (Object str : ftv) {
            if (strList.contains(str.toString())) return false;
        }
        return true;
    }

    @Action
    public void then(Facts facts) {

    }
}
