/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.rules.support.composite.CompositeRule;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/5/8
 */
@Rule(name = StrategyConstants.C22, description = "存在对象满足")
public class ARRAY_ROW_EXIST_INCLUDERule extends PropertiesRule {

    private final double zoneOffset;

    public ARRAY_ROW_EXIST_INCLUDERule(JSONObject ruleJson, double zoneOffset) {
        super(ruleJson);
        this.zoneOffset = zoneOffset;
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        if (StrategyConstants.ARRAY_ROW_TYPE.equals(columnType)) {
            List<Facts> factList = CommonUtils.getFactList(value);
            JSONArray fits = ruleJson.optJSONArray("filts");
            int relation = ruleJson.optInt("relation");
            CompositeRule compositeRule = CommonUtils.parseCompound(relation, fits, zoneOffset);
            return isRowTypeCondition(compositeRule, factList);
        }
        return false;
    }

    protected boolean isRowTypeCondition(CompositeRule compositeRule, List<Facts> factList) {
        if (compositeRule == null) return false;
        for (Facts fact : factList) {
            if (compositeRule.evaluate(fact)) return true;
        }
        return false;
    }


    @Action
    public void then(Facts facts) {

    }

}
