/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;
import org.json.JSONObject;
import java.util.List;
import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.rules.support.composite.CompositeRule;
import cn.thinkingdata.strategy.utils.StrategyConstants;
/**
 * @author liulongbing
 * @since 2024/5/8
 */
@Rule(name = StrategyConstants.C24, description = "全部对象满足")
public class ARRAY_ROW_ALL_INCLUDERule extends ARRAY_ROW_EXIST_INCLUDERule {

    public ARRAY_ROW_ALL_INCLUDERule(JSONObject ruleJson, double zoneOffset) {
        super(ruleJson, zoneOffset);
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Override
    protected boolean isRowTypeCondition(CompositeRule compositeRule, List<Facts> factList) {
        if (compositeRule == null) return false;
        for (Facts fact : factList) {
            if (!compositeRule.evaluate(fact)) return false;
        }
        return true;
    }

    @Action
    public void then(Facts facts) {

    }

}
