/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.rules.filters.factory.RuleFactory;
import cn.thinkingdata.strategy.rules.support.composite.UnitRuleGroup;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/5/8
 */
@Rule(name = StrategyConstants.C17, description = "元素位置")
public class ARRAY_ITEM_POSRule extends PropertiesRule {

    private static final String ARRAY_COLUM_NAME = "array_column_name";

    private final double zoneOffset;

    public ARRAY_ITEM_POSRule(JSONObject ruleJson, double zoneOffset) {
        super(ruleJson);
        this.zoneOffset = zoneOffset;
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        if (StrategyConstants.ARRAY_VARCHAR_TYPE.equals(columnType)) {
            if (ftv.size() >= 3) {
                int pos = ( int ) ftv.get(0);
                List<String> valueList = CommonUtils.getValueList(value);
                if (valueList.size() <= Math.abs(pos)) return false;
                String valueStr;
                if (pos >= 1) {
                    valueStr = valueList.get(pos -1);
                } else {
                    valueStr = valueList.get(valueList.size() + pos);
                }
                Facts valueFact = new Facts();
                valueFact.put(ARRAY_COLUM_NAME, valueStr);
                String symbol = ( String ) ftv.get(1);
                JSONArray newFtv = new JSONArray();
                for (int i = 2; i < ftv.size(); i++) {
                    newFtv.put(ftv.get(i));
                }
                JSONObject arrayRuleJson = CommonUtils.buildArrayPositionRule(symbol, ARRAY_COLUM_NAME, newFtv);
                if (arrayRuleJson == null) return false;
                Object obj = RuleFactory.createFilterRule(arrayRuleJson, zoneOffset);
                if (obj == null) return false;
                UnitRuleGroup unitRuleGroup = new UnitRuleGroup();
                unitRuleGroup.addRule(obj);
                return unitRuleGroup.evaluate(valueFact);
            }
        }
        return false;
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Action
    public void then(Facts facts) {

    }
}
