/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.filters.contition;

import org.json.JSONObject;

import java.util.List;

import cn.thinkingdata.strategy.rules.annotation.Action;
import cn.thinkingdata.strategy.rules.annotation.Condition;
import cn.thinkingdata.strategy.rules.annotation.Rule;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;

/**
 * @author liulongbing
 * @since 2024/5/8
 */
@Rule(name = StrategyConstants.C15, description = "存在元素")
public class ARRAY_INCLUDE_ITEMRule extends PropertiesRule {

    public ARRAY_INCLUDE_ITEMRule(JSONObject ruleJson) {
        super(ruleJson);
    }

    @Override
    public boolean executeWhen(Object value, Facts facts) {
        if (StrategyConstants.ARRAY_VARCHAR_TYPE.equals(columnType)) {
            return isArrayVarCondition(CommonUtils.getValueList(value));
        }
        return false;
    }

    protected boolean isArrayVarCondition(List<String> strList) {
        for (Object str : ftv) {
            if (strList.contains(str.toString())) return true;
        }
        return false;
    }

    @Condition
    public boolean when(Facts facts) {
        return isCondition(facts);
    }

    @Action
    public void then(Facts facts) {

    }

}
