/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.api;

/**
 * This interface represents a rule's action.
 *
 * @author llb
 */
@FunctionalInterface
public interface Action {

    /**
     * Execute the action when the rule's condition evaluates to true.
     *
     * @param facts known at the time of execution of the action
     * @throws Exception when unable to execute the action
     */
    void execute(Facts facts) throws Exception;
}
