/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.rules.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to mark a class as a rule.
 *
 * @author llb
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Rule {

    /**
     * The rule name which must be unique within a rules registry.
     *
     * @return The rule name
     */
    String name() default cn.thinkingdata.strategy.rules.api.Rule.DEFAULT_NAME;

    /**
     * The rule description.
     *
     * @return The rule description
     */
    String description() default cn.thinkingdata.strategy.rules.api.Rule.DEFAULT_DESCRIPTION;

    /**
     * The rule priority.
     *
     * @return The rule priority
     */
    int priority() default cn.thinkingdata.strategy.rules.api.Rule.DEFAULT_PRIORITY;

}
