/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.receiver;

import cn.thinkingdata.remoteconfig.receiver.TDRemoteStatusObserver;
import cn.thinkingdata.strategy.core.task.TaskFlowManager;
import cn.thinkingdata.strategy.task.StrategyTaskManager;

/**
 * @author liulongbing
 * @since 2024/3/7
 */
public class TDRemoteReceiver implements TDRemoteStatusObserver {
    @Override
    public void onChangeAccountSuccess(String appId, String tempCode, String clientUserId) {
        stopTask(appId, tempCode,clientUserId);
    }

    @Override
    public void onConfigExpired(String appId, String tempCode, String clientUserId) {
        stopTask(appId, tempCode,clientUserId);
    }

    private void stopTask(String appId, String tempCode, String clientUserId) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                try {
                    TaskFlowManager.getInstance(appId).stopTasks(tempCode,clientUserId);
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onConfigApplySuccess(String appId, String tempCode,String clientUserId) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                try {
                    TaskFlowManager.getInstance(appId).applyNewConfig(tempCode,clientUserId);
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }
}
