/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.receiver;

import org.json.JSONObject;

import cn.thinkingdata.core.receiver.TDObserver;
import cn.thinkingdata.strategy.core.task.TaskFlowManager;
import cn.thinkingdata.strategy.task.StrategyTaskManager;

/**
 * @author liulongbing
 * @since 2024/3/8
 */
public class TDEventReceiver implements TDObserver {
    @Override
    public void onSdkInitReceived(String s) {

    }

    @Override
    public void onLoginReceived(String s, String s1, String s2) {

    }

    @Override
    public void onDistinctIdReceived(String s, String s1, String s2) {

    }

    @Override
    public void onLogoutReceived(String s, String s1) {

    }

    @Override
    public void onDataEnqueued(String s, JSONObject jsonObject) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                TaskFlowManager.getInstance(s).triggerEvent(jsonObject,0);
            }
        });
    }

    @Override
    public void onTimeCalibrated() {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                for (String s : TaskFlowManager.instances.keySet()) {
                    TaskFlowManager.getInstance(s).deleteInvalidTasks();
                    break;
                }
            }
        });
    }
}
