/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.plugin;

import android.content.Context;
import android.text.TextUtils;

import java.util.List;

import cn.thinkingdata.core.TDSettings;
import cn.thinkingdata.core.router.TRouterMap;
import cn.thinkingdata.core.router.plugin.IPlugin;
import cn.thinkingdata.core.router.plugin.MethodCall;
import cn.thinkingdata.strategy.TDStrategy;
import cn.thinkingdata.strategy.TDStrategySettings;
import cn.thinkingdata.ta_apt.TRoute;

/**
 * @author liulongbing
 * @since 2024/5/20
 */
@TRoute(path = TRouterMap.STRATEGY_PLUGIN_ROUTE_PATH)
public class StrategyPlugin implements IPlugin {

    @Override
    public void onMethodCall(MethodCall methodCall) {
        try {
            String methodName = methodCall.method;
            if (TextUtils.equals(methodName, "init")) {
                Context context = methodCall.argument("context");
                List<TDSettings> list = methodCall.argument("settings");
                if (context == null || list == null) return;
                for (TDSettings settings : list) {
                    TDStrategySettings setting = new TDStrategySettings(settings.appId, settings.serverUrl);
                    if (settings.mode == TDSettings.TDMode.DEBUG || settings.mode == TDSettings.TDMode.DEBUG_ONLY) {
                        setting.mode = TDStrategy.TDStrategyMode.DEBUG;
                    } else {
                        setting.mode = TDStrategy.TDStrategyMode.NORMAL;
                    }
                    TDStrategy.enableLog(settings.enableLog);
                    TDStrategy.init(context, setting);
                }
            }
        } catch (Exception ignore) {
        }
    }
}
