/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.trigger;

import org.json.JSONObject;

import cn.thinkingdata.strategy.core.task.TaskFlow;

/**
 * @author liulongbing
 * @since 2024/3/26
 */
public class TriggerRuleFactory {

    public static ITriggerRule createTriggerRule(TaskFlow flow, JSONObject rule, int eventTriggerType, int triggerId) {
        ITriggerRule triggerRule = null;
        switch (eventTriggerType) {
            case 1:
                triggerRule = new ContinueTriggerRule(flow, rule, triggerId);
                break;
            case 3:
                triggerRule = new EveryTriggerRule(flow, rule, triggerId);
                break;
            default:
                break;
        }
        return triggerRule;
    }

}
