/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.result;

import android.os.Handler;
import android.os.Looper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liulongbing
 * @since 2024/3/15
 */
public class TDStrategyResultObservable {

    private volatile static TDStrategyResultObservable instance = null;

    private final List<TDStrategyResultListener> listeners;

    private final Handler mHandler = new Handler(Looper.getMainLooper());

    private TDStrategyResultObservable() {
        listeners = new ArrayList<>();
    }

    public static TDStrategyResultObservable getInstance() {
        if (instance == null) {
            synchronized (TDStrategyResultObservable.class) {
                if (instance == null) {
                    instance = new TDStrategyResultObservable();
                }
            }
        }
        return instance;
    }

    public void addListener(TDStrategyResultListener listener) {
        synchronized (this) {
            //暂时只允许添加一个监听
            if (listeners.size() == 0) {
                listeners.add(listener);
            }
        }
    }

    public void triggerResult(TDStrategyResult result) {
        synchronized (this) {
            for (TDStrategyResultListener listener : listeners) {
                if (listener == null) continue;
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        listener.onTriggerResult(result);
                    }
                });
            }
        }
    }

    public boolean isObserverEmpty() {
        return listeners.isEmpty();
    }


}
