/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;
import java.util.Calendar;

/**
 * @author liulongbing
 * @since 2024/3/22
 */
public class WeekScrollTimeCycle extends DailyScrollTimeCycle {

    public WeekScrollTimeCycle(TaskPeriodInfo periodInfo, PeriodScrollInfo scrollInfo) {
        super(periodInfo, scrollInfo);
        if (scrollInfo == null) {
            scrollInfo = new PeriodScrollInfo();
            scrollInfo.timeCycleNumber = 1;
            scrollInfo.timeCycleUnit = TimeCycleUnit.WEEK;
            scrollInfo.startNumber = 0;
        } else {
            if (scrollInfo.timeCycleNumber < 1) {
                scrollInfo.timeCycleNumber = 1;
            }
            if (scrollInfo.startNumber < 1 || scrollInfo.startNumber >= 7) {
                //如果不合法 周日作为一周的第一天
                scrollInfo.startNumber = 0;
            }
        }
    }

    @Override
    protected long getStartOfTimestamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(startTime);

        int currentDayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
        int daysToSubtract = currentDayOfWeek - Calendar.SUNDAY;
        calendar.add(Calendar.DAY_OF_MONTH, -daysToSubtract);

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    protected int getStartDay() {
        return scrollInfo.startNumber;
    }

    @Override
    protected int getCycleNumber() {
        return scrollInfo.timeCycleNumber * 7;
    }
}
