/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;

import android.util.Pair;

import java.util.Calendar;

import cn.thinkingdata.strategy.utils.AnalyticUtils;

/**
 * @author liulongbing
 * @since 2024/4/25
 */
public class TouchScrollTimeCycle extends AbstractTimeCycle {

    public TouchScrollTimeCycle(TaskPeriodInfo periodInfo, PeriodScrollInfo scrollInfo) {
        super(periodInfo, scrollInfo);
    }

    @Override
    public Pair<Long, Long> getCurrentTimeCycle() {
        long currentTimeStamp = AnalyticUtils.getCurrentTimeStamp();
        long dayStartTimeStamp = getDayStartTimestamp(currentTimeStamp);
        long end = dayStartTimeStamp + 24 * 60 * 60 * 1000;
        long start = end - ( long ) getCycleNumber() * 24 * 60 * 60 * 1000;
        return new Pair<>(start, end);
    }

    private int getCycleNumber() {
        if (scrollInfo == null) return 0;
        if (scrollInfo.timeCycleUnit == TimeCycleUnit.DAY) {
            return scrollInfo.timeCycleNumber;
        } else if (scrollInfo.timeCycleUnit == TimeCycleUnit.WEEK) {
            return scrollInfo.timeCycleNumber * 7;
        }
        return 0;
    }

    private long getDayStartTimestamp(long timeStamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStamp);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public boolean isWithInPeriod() {
        return true;
    }

}
