/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;

import android.util.Pair;

import cn.thinkingdata.strategy.utils.AnalyticUtils;

/**
 * @author liulongbing
 * @since 2024/3/22
 */
public class SlideTimeCycle extends AbstractTimeCycle {

    public SlideTimeCycle(TaskPeriodInfo periodInfo, PeriodScrollInfo sInfo) {
        super(periodInfo, sInfo);
    }

    @Override
    public Pair<Long, Long> getCurrentTimeCycle() {
        long currentTimeStamp = AnalyticUtils.getCurrentTimeStamp();
        int minutes = getMinutes();
        if (minutes == 0) {
            return new Pair<>(startTime, endTime);
        }
        long beforeTimestamp = currentTimeStamp - ( long ) minutes * 60 * 1000;
        if (beforeTimestamp < startTime) {
            beforeTimestamp = startTime;
        }
        if (currentTimeStamp > endTime) {
            currentTimeStamp = endTime;
        }
        return new Pair<>(beforeTimestamp, currentTimeStamp);
    }

    protected int getMinutes() {
        if (null == scrollInfo) return 0;
        if (scrollInfo.timeCycleUnit == TimeCycleUnit.WEEK) {
            return scrollInfo.timeCycleNumber * 7 * 24 * 60;
        } else if (scrollInfo.timeCycleUnit == TimeCycleUnit.DAY) {
            return scrollInfo.timeCycleNumber * 24 * 60;
        } else if (scrollInfo.timeCycleUnit == TimeCycleUnit.HOUR) {
            return scrollInfo.timeCycleNumber * 60;
        } else if (scrollInfo.timeCycleUnit == TimeCycleUnit.MINUTE) {
            return scrollInfo.timeCycleNumber;
        }
        return 0;
    }
}
