/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;

import java.util.Calendar;

/**
 * @author liulongbing
 * @since 2024/3/22
 */
public class MonthScrollTimeCycle extends DailyScrollTimeCycle {

    private int startYear;
    private int startMonth;

    public MonthScrollTimeCycle(TaskPeriodInfo periodInfo, PeriodScrollInfo scrollInfo) {
        super(periodInfo, scrollInfo);
        if (scrollInfo == null) {
            scrollInfo = new PeriodScrollInfo();
            scrollInfo.timeCycleNumber = 1;
            scrollInfo.timeCycleUnit = TimeCycleUnit.MONTH;
            scrollInfo.startNumber = 1;
        } else {
            if (scrollInfo.timeCycleNumber < 1) {
                scrollInfo.timeCycleNumber = 1;
            }
            if (scrollInfo.startNumber < 1) {
                scrollInfo.startNumber = 1;
            }
            if (scrollInfo.startNumber >= 28) {
                scrollInfo.startNumber = 28;
            }
        }
        scrollInfo.startHour = 0;
        scrollInfo.startMinute = 0;
    }

    @Override
    protected long getStartOfTimestamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(startTime);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        startYear = calendar.get(Calendar.YEAR);
        startMonth = calendar.get(Calendar.MONTH) + 1;

        return calendar.getTimeInMillis();
    }

    @Override
    protected int getStartDay() {
        return scrollInfo.startNumber - 1;
    }

    @Override
    protected int getCycleNumber() {
        int day = 0;
        for (int i = 0; i < scrollInfo.timeCycleNumber; i++) {
            day = day + getDayOfMonth();
        }
        return day;
    }

    public int getDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(startYear, startMonth - 1, 1);
        startMonth = startMonth + 1;
        if (startMonth > 12) {
            startMonth = 1;
            startYear = startYear + 1;
        }
        return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    }


}
