/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;

import android.os.SystemClock;
import android.util.Pair;

import cn.thinkingdata.strategy.core.task.TaskFlowManager;
import cn.thinkingdata.strategy.utils.AnalyticUtils;

/**
 * @author liulongbing
 * @since 2024/3/22
 */
public class ClientStartTimeCycle extends AbstractTimeCycle {

    public ClientStartTimeCycle(TaskPeriodInfo periodInfo) {
        super(periodInfo, null);
    }

    @Override
    public Pair<Long, Long> getCurrentTimeCycle() {
        long start;
        if (TaskFlowManager.clientStartTime == 0) {
            Pair<Long, Boolean> pair = AnalyticUtils.getCurrentTimePair();
            if (pair.second) {
                //如果时间是准确的 校准启动时间
                TaskFlowManager.clientStartTime = pair.first - (SystemClock.elapsedRealtime() - TaskFlowManager.clientStartElapsedRealtime);
                start = TaskFlowManager.clientStartTime;
            } else {
                start = System.currentTimeMillis() - (SystemClock.elapsedRealtime() - TaskFlowManager.clientStartElapsedRealtime);
            }
        } else {
            start = TaskFlowManager.clientStartTime;
        }
        return new Pair<>(start, endTime);
    }

}
