/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.period;

import cn.thinkingdata.core.utils.TimeUtil;
import cn.thinkingdata.strategy.utils.AnalyticUtils;

/**
 * @author liulongbing
 * @since 2024/3/21
 */
public abstract class AbstractTimeCycle implements ITimeCycle {

    protected long startTime;
    protected long endTime;
    protected PeriodScrollInfo scrollInfo;


    public AbstractTimeCycle(TaskPeriodInfo periodInfo, PeriodScrollInfo scrollInfo) {
        if (null != periodInfo) {
            if (periodInfo.periodStartStamp != 0 && periodInfo.periodEndStamp != 0) {
                this.startTime = periodInfo.periodStartStamp;
                this.endTime = periodInfo.periodEndStamp;
            } else {
                this.startTime = TimeUtil.getFormatDate(periodInfo.periodStart, periodInfo.timePattern, periodInfo.zoneOffset).getTime();
                this.endTime = TimeUtil.getFormatDate(periodInfo.periodEnd, periodInfo.timePattern, periodInfo.zoneOffset).getTime();
            }
        }
        if (this.startTime == 0L) {
            this.startTime = AnalyticUtils.getCurrentTimeStamp();
        }
        if (this.endTime == 0L) {
            this.endTime = AnalyticUtils.getCurrentTimeStamp();
        }
        this.scrollInfo = scrollInfo;
    }

    @Override
    public boolean isWithInPeriod() {
        long currentTime = AnalyticUtils.getCurrentTimeStamp();
        return currentTime >= startTime && currentTime <= endTime;
    }
}
