/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.frequency;

import android.util.Pair;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import cn.thinkingdata.strategy.core.period.DailyScrollTimeCycle;
import cn.thinkingdata.strategy.core.period.PeriodLimitFactory;
import cn.thinkingdata.strategy.core.period.PeriodScrollInfo;
import cn.thinkingdata.strategy.core.period.SlideTimeCycle;
import cn.thinkingdata.strategy.core.period.TaskPeriodInfo;
import cn.thinkingdata.strategy.core.period.TimeCycleUnit;
import cn.thinkingdata.strategy.core.period.TouchScrollTimeCycle;
import cn.thinkingdata.strategy.core.task.TaskFlow;
import cn.thinkingdata.strategy.storage.db.StrategyDataBaseHelper;
import cn.thinkingdata.strategy.storage.db.TouchLimitInfo;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.TDStrategyLog;

/**
 * @author liulongbing
 * @since 2024/3/29
 */
public class UserFatigueControl extends AbstractTaskLimit {

    private TouchLimitInfo mTouchLimitInfo;

    public UserFatigueControl(TaskFlow mTaskFlow, JSONObject json) {
        super(mTaskFlow, json);
    }

    @Override
    void parseLimitInfo(JSONObject json) {
        if (json == null) return;
        enableLimit = json.optBoolean("enableChannelTouchLimits");
        if (!enableLimit) return;
        String ruleDefStr = json.optString("channelTouchLimitsRuleDef");
        JSONArray touchLists = null;
        try {
            touchLists = new JSONArray(ruleDefStr);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if (touchLists == null) return;
        Pair<Long, Long> pair = mTaskFlow.mTimeCycle.getCurrentTimeCycle();
        TaskPeriodInfo info = new TaskPeriodInfo();
        info.periodStartStamp = pair.first;
        info.periodEndStamp = pair.second;
        for (int i = 0; i < touchLists.length(); i++) {
            JSONObject item = touchLists.optJSONObject(i);
            if (item == null) continue;
            int maxTimes = item.optInt("maxTimes");
            PeriodScrollInfo pInfo = new PeriodScrollInfo();
            pInfo.timeCycleNumber = item.optInt("timeCycleNumber");
            pInfo.timeCycleUnit = PeriodLimitFactory.getTimeCycleUnit(item.optString("timeCycleUnit"));
            mLimits.add(new Pair<>(new TouchScrollTimeCycle(info, pInfo), maxTimes));
        }
    }

    private TouchLimitInfo getTouchLimitInfo() {
        if (mTouchLimitInfo == null) {
            mTouchLimitInfo = new TouchLimitInfo(mTaskFlow.appId, mTaskFlow.getPushId(), mTaskFlow.channelId);
        }
        return mTouchLimitInfo;
    }

    @Override
    int getLimitCount(long start, long end) {
        TouchLimitInfo tInfo = getTouchLimitInfo();
        TDStrategyLog.i("Touch Limit PushID: " + tInfo.pushId + " Start : " + CommonUtils.getLogFormatTime(start) + " End : " + CommonUtils.getLogFormatTime(end));
        return StrategyDataBaseHelper.getHelper().getTouchLimitCount(tInfo, start, end);
    }

    @Override
    void addLimitStorage() {
        StrategyDataBaseHelper.getHelper().addTouchLimit(getTouchLimitInfo());
    }

}
