/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.frequency;

import android.util.Pair;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import cn.thinkingdata.remoteconfig.TDRemoteConfig;
import cn.thinkingdata.strategy.core.period.ITimeCycle;
import cn.thinkingdata.strategy.core.task.TaskFlow;
import cn.thinkingdata.strategy.utils.TDStrategyLog;

/**
 * @author liulongbing
 * @since 2024/3/29
 */
public abstract class AbstractTaskLimit implements ITaskLimit {

    protected final TaskFlow mTaskFlow;
    protected boolean enableLimit = false;
    protected List<Pair<ITimeCycle, Integer>> mLimits;
    protected String mClientUserId;

    public AbstractTaskLimit(TaskFlow mTaskFlow, JSONObject json) {
        this.mTaskFlow = mTaskFlow;
        this.mLimits = new ArrayList<>();
        this.mClientUserId = mTaskFlow.clientUserId;
        try {
            parseLimitInfo(json);
        } catch (Exception ignore) {
        }
    }

    abstract void parseLimitInfo(JSONObject json) throws JSONException;

    @Override
    public boolean isLimit() {
        if (!enableLimit) return false;
        boolean isLimit = false;
        for (Pair<ITimeCycle, Integer> mLimit : mLimits) {
            ITimeCycle timeCycle = mLimit.first;
            if (!timeCycle.isWithInPeriod()) continue;
            Pair<Long, Long> pair = timeCycle.getCurrentTimeCycle();
            int count = getLimitCount(pair.first, pair.second);
            if (count < 0) continue;
            count = count + 1;
            TDStrategyLog.i("Current Count: " + count + " Target Count: " + mLimit.second);
            isLimit = count > mLimit.second;
            if (isLimit) break;
        }
        return isLimit;
    }

    abstract int getLimitCount(long start, long end);

    abstract void addLimitStorage();

    @Override
    public void addLimitCount() {
        if (this.enableLimit && this.mLimits.size() > 0) {
            addLimitStorage();
        }
    }
}
