/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy.core.audience;

import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import cn.thinkingdata.remoteconfig.TDRemoteConfig;
import cn.thinkingdata.strategy.core.task.TaskFlow;
import cn.thinkingdata.strategy.rules.api.Facts;
import cn.thinkingdata.strategy.rules.support.composite.CompositeRule;
import cn.thinkingdata.strategy.task.TDClientValueManager;
import cn.thinkingdata.strategy.utils.AnalyticUtils;
import cn.thinkingdata.strategy.utils.CommonUtils;
import cn.thinkingdata.strategy.utils.TDStrategyLog;

/**
 * @author liulongbing
 * @since 2024/3/12
 */
public class TargetAudienceManager {

    private final boolean isTargetUser;
    private CompositeRule compositeRule;
    private final String pushId;
    private final List<String> columns = new ArrayList<>();
    private final TaskFlow flow;
    private String finalPushId;

    public TargetAudienceManager(TaskFlow flow, boolean isTargetUser, JSONObject clientQp, String pushId) {
        this.isTargetUser = isTargetUser;
        this.pushId = pushId;
        this.flow = flow;
        try {
            int relation = clientQp.optInt("relation");
            JSONArray fitArray = clientQp.optJSONArray("filts");
            compositeRule = CommonUtils.parseCompound(relation, fitArray, flow.zoneOffset, columns);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isTargetUser(Facts facts) {
        if (facts == null) return false;
        //服务端目标用户判断
        if (!this.isTargetUser) {
            flow.mTriggerRecord.status = AnalyticUtils.TARGET_USER_IS_FALSE;
            AnalyticUtils.trackTriggerEvent(flow.mTriggerRecord);
            return false;
        }

        //客户端受众条件判断
        boolean isTargetRule;
        //客户端条件判断的值可能从RC获取
        for (String column : columns) {
            Object value = TDClientValueManager.getInstance().get(column);
            //facts是从properties转过来的 如果不是预置属性 删除
            if (!column.startsWith("#")) {
                facts.remove(column);
            }
            if (value != null) {
                facts.put(column, value);
            }
        }
        if (null != this.compositeRule) {
            TDStrategyLog.i("TargetAudience------start trigger rules------");
            isTargetRule = this.compositeRule.evaluate(facts);
            TDStrategyLog.i("TargetAudience------end trigger rules------result is " + isTargetRule);
        } else {
            isTargetRule = true;
        }
        if (!isTargetRule) {
            flow.mTriggerRecord.status = AnalyticUtils.CLIENT_QP_IS_FALSE;
            AnalyticUtils.trackTriggerEvent(flow.mTriggerRecord);
            return false;
        }

        //PushID是否满足
        this.finalPushId = getPushId(facts);
        TDStrategyLog.i("Push ID :" + this.finalPushId);
        if (TextUtils.isEmpty(this.finalPushId)) {
            flow.mTriggerRecord.status = AnalyticUtils.PUSH_ID_IS_NULL;
            AnalyticUtils.trackTriggerEvent(flow.mTriggerRecord);
            return false;
        }
        return true;
    }

    private String getFinalPushId(Facts facts) {
        if (TextUtils.isEmpty(this.pushId) || facts == null) return "";
        if (!this.pushId.contains("client:")) {
            return this.pushId;
        }
        String[] splits = this.pushId.split(":");
        if (splits.length < 2) return "";
        String columnName = splits[1];
        Object s1 = facts.get(columnName);
        if (CommonUtils.isEmpty(s1)) {
            s1 = TDClientValueManager.getInstance().get(columnName);
        }
        if (!CommonUtils.isEmpty(s1)) {
            return s1.toString();
        }
        return "";
    }

    public String getPushId(Facts facts) {
        if (TextUtils.isEmpty(this.finalPushId)) {
            this.finalPushId = getFinalPushId(facts);
        }
        return this.finalPushId;
    }

}
