/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.strategy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import org.json.JSONObject;

import cn.thinkingdata.core.receiver.TDAnalyticsObservable;
import cn.thinkingdata.remoteconfig.TDRemoteConfig;
import cn.thinkingdata.remoteconfig.TDRemoteConfigSettings;
import cn.thinkingdata.remoteconfig.receiver.TDRemoteConfigObservable;
import cn.thinkingdata.remoteconfig.sysconfig.SystemConfigManager;
import cn.thinkingdata.strategy.core.result.TDStrategyResultListener;
import cn.thinkingdata.strategy.core.result.TDStrategyResultObservable;
import cn.thinkingdata.strategy.core.task.TaskFlowManager;
import cn.thinkingdata.strategy.receiver.TDEventReceiver;
import cn.thinkingdata.strategy.receiver.TDRemoteReceiver;
import cn.thinkingdata.strategy.task.StrategyTaskManager;
import cn.thinkingdata.strategy.task.TDClientValueManager;
import cn.thinkingdata.strategy.utils.SpUtils;
import cn.thinkingdata.strategy.utils.StrategyConstants;
import cn.thinkingdata.strategy.utils.TDStrategyLog;
import cn.thinkingdata.strategysdk.BuildConfig;

/**
 * @author liulongbing
 * @since 2024/3/8
 */
public class TDStrategy {

    @SuppressLint("StaticFieldLeak")
    public static Context mContext;

    private static boolean isHasInit = false;

    public static void init(Context context, String appId, String serverUrl) {
        init(context, new TDStrategySettings(appId, serverUrl));
    }

    static {
        TDAnalyticsObservable.getInstance().registerObserver(new TDEventReceiver());
        TDRemoteConfigObservable.getInstance().addObserver(new TDRemoteReceiver());
    }

    public static void init(Context context, TDStrategySettings settings) {
        if (context == null || settings == null) return;
        if (TextUtils.isEmpty(settings.appId) || TextUtils.isEmpty(settings.serverUrl)) return;
        mContext = context.getApplicationContext();
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                if (SystemConfigManager.getInstance().isStrategyStop(settings.appId, BuildConfig.VERSION_NAME))
                    return;
                TDRemoteConfigSettings remoteConfigSettings = new TDRemoteConfigSettings();
                remoteConfigSettings.appId = settings.appId;
                remoteConfigSettings.serverUrl = settings.serverUrl;
                remoteConfigSettings.templateCode = StrategyConstants.STRATEGY_TEMPLATE_CODE;
                if (settings.mode == TDStrategyMode.DEBUG) {
                    remoteConfigSettings.mode = TDRemoteConfigSettings.TDRemoteConfigMode.DEBUG;
                } else {
                    remoteConfigSettings.mode = TDRemoteConfigSettings.TDRemoteConfigMode.NORMAL;
                }
                TDRemoteConfig.init(context, remoteConfigSettings);
                if (!isHasInit) {
                    SpUtils.getInstance().init(mContext);
                    TDStrategyLog.initLogTag();
                }
                if (!TaskFlowManager.instances.containsKey(settings.appId)) {
                    TaskFlowManager.getInstance(settings.appId).loadLocalTask();
                }
                isHasInit = true;
                TDStrategyLog.i("TDStrategy SDK init success with appId = " + settings.appId + " and version = " + BuildConfig.VERSION_NAME);
            }
        });
    }

    public static void setTriggerListener(TDStrategyResultListener listener) {
        TDStrategyResultObservable.getInstance().addListener(listener);
    }

    public static void enableLog(boolean enable) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                if (!TDStrategyLog.getPropLogTag()) {
                    TDStrategyLog.setEnableLog(enable);
                }
            }
        });
    }

    public static void addClientParams(JSONObject params) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                if (!isHasInit) return;
                TDClientValueManager.getInstance().addClientParams(params);
            }
        });
    }

    public static void removeClientParam(String key) {
        StrategyTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                if (!isHasInit) return;
                TDClientValueManager.getInstance().removeClientParam(key);
            }
        });
    }

//    public static void fetch() {
//        TDRemoteConfig.fetch("", StrategyConstants.STRATEGY_TEMPLATE_CODE);
//    }

    public enum TDStrategyMode {
        NORMAL,
        DEBUG
    }
}
