/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.utils;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;

import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

/**
 * <  >.
 *
 * @author liulongbing
 * @since 2023/11/1
 */
public class XmlUtil {

    public static JSONObject parseXml(Context context, int resId) {
        JSONObject json = new JSONObject();
        try {
            // 获取XmlResourceParser对象
            XmlResourceParser xrp = context.getResources().getXml(resId);
            if (xrp == null) return json;
            // 找到文件的开始
            while (xrp.getEventType() != XmlPullParser.START_TAG) {
                xrp.next();
            }
            // 找到标签
            while (xrp.getEventType() != XmlPullParser.END_TAG) {
                if (xrp.getEventType() == XmlPullParser.START_TAG) {
                    String tagName = xrp.getName();
                    if (TextUtils.equals("value", tagName)) {
                        String key = xrp.getAttributeValue(null, "key");
                        String value = xrp.nextText();
                        if (isLong(value)) {
                            json.put(key, Long.parseLong(value));
                        } else if (isDouble(value)) {
                            json.put(key, Double.parseDouble(value));
                        } else if (isBoolean(value)) {
                            json.put(key, Boolean.parseBoolean(value));
                        } else {
                            json.put(key, value);
                        }
                    }
                }
                xrp.next();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        } catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        } catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return Boolean.parseBoolean(s);
    }

}
