/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.utils;
import android.content.Context;
import android.content.SharedPreferences;

import cn.thinkingdata.remoteconfig.core.TDRemoteInstance;

/**
 * @author liulongbing
 * @since 2024/5/13
 */
public class SpUtils {

    public static final String KEY_SYSTEM_CONFIG = "td_system_config_";
    public static final String KEY_REMOTE_CONFIG_SP = "td_remote_config_sp";
    public static final String KEY_CLIENT_VALUE = "td_client_value";

    private SharedPreferences sp;
    private static SpUtils instance;

    private SpUtils() {
    }

    public void init(Context context) {
        if (sp == null) {
            sp = context.getSharedPreferences(KEY_REMOTE_CONFIG_SP, Context.MODE_PRIVATE);
        }
    }

    public static SpUtils getInstance() {
        if (instance == null) {
            instance = new SpUtils();
        }
        return instance;
    }

    public void putString(String key, String value) {
        if (sp == null) return;
        sp.edit().putString(key, value).apply();
    }

    public String getString(String key, String defValue) {
        if (sp == null) return defValue;
        return sp.getString(key, defValue);
    }

    public void putLong(String key, long value) {
        if (sp == null) return;
        sp.edit().putLong(key, value).apply();
    }

    public long getLong(String key, long defValue) {
        if (sp == null) return defValue;
        return sp.getLong(key, defValue);
    }

    public String getOldStrategyValue() {
        if (TDRemoteInstance.getInstance("").mContext != null) {
            SharedPreferences strategySp = TDRemoteInstance.getInstance("").mContext.getSharedPreferences("td_strategy_sp", Context.MODE_PRIVATE);
            return strategySp.getString(KEY_CLIENT_VALUE, "{}");
        }
        return "{}";
    }
}
