/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.utils;

/**
 * @author liulongbing
 * @since 2023/12/8
 */
public class LogUtil {

    private static final String TAG = "TDRemoteConfigSDK";
    public static boolean mEnableLog = false;

    public static void setEnableLog(boolean enable) {
        mEnableLog = enable;
    }

    public static void i(String tag, String msg) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.i(tag, msg);
        }
    }

    public static void i(String msg) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.i(TAG, "[ThinkingData] Info: " + msg);
        }
    }

    public static void i1(String format, Object... args) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.i(TAG, "[ThinkingData] Info: " + String.format(format, args));
        }
    }

    public static void i(String tag, String msg, Throwable t) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.i(tag, msg, t);
        }
    }

    public static void d(String tag, String msg) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.d(tag, msg);
        }
    }

    public static void w(String tag, String msg) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.w(tag, msg);
        }
    }

    public static void e(String msg) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.e(TAG, "[ThinkingData] Error: " + msg);
        }
    }

    public static void e(String msg, Throwable t) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.e(TAG, "[ThinkingData] Error: " + msg, t);
        }
    }

    public static void e(String tag, String msg, Throwable t) {
        if (mEnableLog) {
            cn.thinkingdata.core.utils.LogUtil.e(tag, msg, t);
        }
    }

}
