/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.task;
import java.util.ArrayList;
import java.util.List;
import cn.thinkingdata.remoteconfig.listener.OnFailureListener;
import cn.thinkingdata.remoteconfig.listener.OnSuccessListener;
/**
 *
 * @author liulongbing
 * @create 2023/11/1
 * @since
 */
public class TaskImpl<T> extends Task<T> {

    private final List<OnSuccessListener<T>> successListeners = new ArrayList<>();
    private final List<OnFailureListener> failListeners = new ArrayList<>();


    @Override
    public void onResultSuccess(T result) {
        for (OnSuccessListener<T> successListener : successListeners) {
            if (null != successListener) {
                successListener.onSuccess(result);
            }
        }
    }

    @Override
    public void onResultError(int code, String error) {
        for (OnFailureListener failListener : failListeners) {
            if (null != failListener) {
                failListener.onFailure(code, error);
            }
        }
    }

    @Override
    public Task<T> addOnSuccessListener(OnSuccessListener<T> listener) {
        this.successListeners.add(listener);
        return this;
    }

    @Override
    public Task<T> addOnFailureListener(OnFailureListener listener) {
        this.failListeners.add(listener);
        return this;
    }

}
