/*
 * Copyright (C) 2025 ThinkingData
 */
package cn.thinkingdata.remoteconfig.task;
import org.json.JSONException;
import org.json.JSONObject;
import cn.thinkingdata.remoteconfig.utils.JsonUtil;
import cn.thinkingdata.remoteconfig.utils.SpUtils;

/**
 * @author liulongbing
 * @since 2025/3/7
 */
public class TDClientValueManager {
    private JSONObject mClientValueParams;
    private final Object mClientValueObj = new Object();

    private static TDClientValueManager instance = null;

    private TDClientValueManager() {

    }

    public static TDClientValueManager getInstance() {
        if (instance == null) {
            synchronized (TDClientValueManager.class) {
                if (instance == null) {
                    instance = new TDClientValueManager();
                }
            }
        }
        return instance;
    }

    private void loadLocalClientParams() {
        if (mClientValueParams == null) {
            try {
                mClientValueParams = new JSONObject(SpUtils.getInstance().getString(SpUtils.KEY_CLIENT_VALUE, ""));
            } catch (Exception e) {
                try {
                    //同步老数据
                    mClientValueParams = new JSONObject(SpUtils.getInstance().getOldStrategyValue());
                } catch (Exception ex) {
                    mClientValueParams = new JSONObject();
                }
            }
        }
    }

    public void addClientParams(JSONObject params) {
        if (params == null) return;
        RemoteTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                synchronized (mClientValueObj) {
                    loadLocalClientParams();
                    try {
                        JsonUtil.mergeJSONObject(params, mClientValueParams);
                        SpUtils.getInstance().putString(SpUtils.KEY_CLIENT_VALUE, mClientValueParams.toString());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void removeClientParam(String key) {
        if (key == null) return;
        RemoteTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                synchronized (mClientValueObj) {
                    loadLocalClientParams();
                    mClientValueParams.remove(key);
                    SpUtils.getInstance().putString(SpUtils.KEY_CLIENT_VALUE, mClientValueParams.toString());
                }
            }
        });
    }

    public void accumulateNum(String key, double num) {
        if (key == null || num == 0) return;
        RemoteTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                synchronized (mClientValueObj) {
                    loadLocalClientParams();
                    try {
                        Object value = mClientValueParams.opt(key);
                        if (value instanceof Integer || value instanceof Double || value instanceof Float || value instanceof Long) {
                            mClientValueParams.put(key, num + Double.parseDouble(value.toString()));
                            SpUtils.getInstance().putString(SpUtils.KEY_CLIENT_VALUE, mClientValueParams.toString());
                        }
                    } catch (Exception ignore) {
                    }

                }
            }
        });
    }


    public Object get(String key) {
        if (key == null) return null;
        synchronized (mClientValueObj) {
            loadLocalClientParams();
            return mClientValueParams.opt(key);
        }
    }

    public JSONObject getAllClientParams() {
        synchronized (mClientValueObj) {
            loadLocalClientParams();
            JSONObject json = new JSONObject();
            try {
                JsonUtil.mergeJSONObject(mClientValueParams,json);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return json;
        }
    }


}
