/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author liulongbing
 * @since 2023/11/2
 */
public class RemoteTaskManager {

    private final ExecutorService mPool;
    private volatile static RemoteTaskManager instance = null;

    public RemoteTaskManager() {
        mPool = new ThreadPoolExecutor(1, 1,
                0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<Runnable>(), new ThreadFactory() {
            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TDRemoteConfig.TaskExecuteThread");
            }
        });
    }

    public static RemoteTaskManager getInstance() {
        if (instance == null) {
            synchronized (RemoteTaskManager.class) {
                instance = new RemoteTaskManager();
            }
        }
        return instance;
    }

    public void addTask(Runnable task) {
        try {
            mPool.execute(task);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
