/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.receiver;

import java.util.ArrayList;
import java.util.List;

import cn.thinkingdata.core.receiver.TDAnalyticsObservable;

/**
 * @author liulongbing
 * @create 2024/3/7
 * @since
 */
public class TDRemoteConfigObservable {

    private volatile static TDRemoteConfigObservable instance = null;

    private final List<TDRemoteStatusObserver> observers;

    private TDRemoteConfigObservable() {
        observers = new ArrayList<>();
    }

    public static TDRemoteConfigObservable getInstance() {
        if (instance == null) {
            synchronized (TDRemoteConfigObservable.class) {
                if (instance == null) {
                    instance = new TDRemoteConfigObservable();
                }
            }
        }
        return instance;
    }

    public void addObserver(TDRemoteStatusObserver observer) {
        if (observer == null) return;
        synchronized (this) {
            observers.add(observer);
        }
    }

    public void removeObserver(TDRemoteStatusObserver observer) {
        synchronized (this) {
            observers.remove(observer);
        }
    }

    public void notifyOnChangeAccount(String appId, String tempCode, String clientUserId) {
        synchronized (this) {
            for (TDRemoteStatusObserver observer : observers) {
                if (null != observer) {
                    observer.onChangeAccountSuccess(appId, tempCode, clientUserId);
                }
            }
        }
    }

    public void notifyOnConfigExpired(String appId, String tempCode, String clientUserId) {
        synchronized (this) {
            for (TDRemoteStatusObserver observer : observers) {
                if (observer != null) {
                    observer.onConfigExpired(appId, tempCode, clientUserId);
                }
            }
        }
    }

    public void notifyOnConfigApplySuccess(String appId, String tempCode, String clientUserId) {
        synchronized (this) {
            for (TDRemoteStatusObserver observer : observers) {
                if (observer != null) {
                    observer.onConfigApplySuccess(appId, tempCode, clientUserId);
                }
            }
        }
    }

}
