/*
 * Copyright (C) 2024 ThinkingData
 */
package cn.thinkingdata.remoteconfig.receiver;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import java.util.ArrayList;
import java.util.List;

import cn.thinkingdata.remoteconfig.task.RemoteTimerTask;

/**
 * @author liulongbing
 * @create 2024/9/9
 */
public class RemoteConfigLifecycleCallBack implements Application.ActivityLifecycleCallbacks {

    private final List<String> activityList = new ArrayList<>();

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
        if (activity == null) return;
        if (activityList.size() == 0) {
            //start
            RemoteTimerTask.getInstance().handlePageCycleUpdate();
        }
        String activityName = activity.getClass().getName();
        if (!activityList.contains(activityName)) {
            activityList.add(activityName);
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
    }

    @Override
    public void onActivityPaused(Activity activity) {
    }

    @Override
    public void onActivityStopped(Activity activity) {
        if (activity == null) return;
        activityList.remove(activity.getClass().getName());
        if (activityList.size() == 0) {
            //end
            RemoteTimerTask.getInstance().handlePageCycleUpdate();
        }
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }

}
