/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig.model;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author liulongbing
 * @create 2023/11/1
 * @since
 */
public class TDConfigValuesImpl implements TDConfigValues {

    private JSONObject values;

    public TDConfigValuesImpl(JSONObject json) {
        if (null != json) {
            this.values = json;
        } else {
            values = new JSONObject();
        }
    }

    public TDConfigValuesImpl(String str) {
        try {
            values = new JSONObject(str);
        } catch (Exception e) {
            values = new JSONObject();
        }
    }

    @Override
    public Boolean getBoolean(String key) {
        Object obj = this.values.opt(key);
        if (obj instanceof Boolean) {
            return this.values.optBoolean(key);
        }
        return false;
    }

    @Override
    public Double getDouble(String key) {
        Object obj = this.values.opt(key);
        if (obj instanceof Double) {
            return this.values.optDouble(key);
        }
        return 0.0;
    }

    @Override
    public Long getLong(String key) {
        Object obj = this.values.opt(key);
        if (obj instanceof Long) {
            return this.values.optLong(key);
        }
        return 0L;
    }

    @Override
    public String getString(String key) {
        Object obj = this.values.opt(key);
        if (obj instanceof String) {
            return this.values.optString(key);
        } else {
            return "";
        }
    }

    @Override
    public JSONObject getAll() {
        try {
            return new JSONObject(this.values.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public JSONObject getAllJson() {
        return this.values;
    }

}
