/*
 * Copyright (C) 2023 ThinkingData
 */
package cn.thinkingdata.remoteconfig;

import android.content.Context;
import android.util.Pair;

import org.json.JSONObject;

import cn.thinkingdata.remoteconfig.core.TDObject;
import cn.thinkingdata.remoteconfig.core.TDRemoteInstance;
import cn.thinkingdata.remoteconfig.task.RemoteTaskManager;
import cn.thinkingdata.remoteconfig.task.TDClientValueManager;
import cn.thinkingdata.remoteconfig.utils.LogUtil;
import cn.thinkingdata.remoteconfigsdk.BuildConfig;

/**
 * @author liulongbing
 * @since 2023/10/24
 */
public class TDRemoteConfig {

    public static void enableLog(boolean enableLog) {
        LogUtil.setEnableLog(enableLog);
    }

    public static void init(Context context, String appId, String serverUrl) {
        TDRemoteConfigSettings settings = new TDRemoteConfigSettings();
        settings.appId = appId;
        settings.serverUrl = serverUrl;
        init(context, settings);
    }

    public static void init(Context context, TDRemoteConfigSettings settings) {
        TDRemoteInstance.init(context, settings);
    }

    public static void clearDefaultValues() {
        TDRemoteInstance instance = TDRemoteInstance.getInstance("");
        if (instance == null) return;
        instance.clearDefaultParams("");
    }

    public static void clearDefaultValues(String appId) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance == null) return;
        instance.clearDefaultParams("");
    }

    public static void setDefaultValues(String filePath) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance("");
        if (instance == null) return;
        instance.applyDefaultParams(filePath, "");
    }

    public static void setDefaultValues(String filePath, String appId) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance == null) return;
        instance.applyDefaultParams(filePath, "");
    }

    public static void setDefaultValues(JSONObject params) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance("");
        if (instance == null) return;
        instance.applyDefaultParams(params, "");
    }

    public static void setDefaultValues(JSONObject params, String appId) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance == null) return;
        instance.applyDefaultParams(params, "");
    }

    public static void setCustomFetchParams(JSONObject params) {
        setCustomFetchParams(params, "", "");
    }

    public static void setCustomFetchParams(JSONObject params, String appId, String tempCode) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance == null) return;
        instance.setCustomParams(params, tempCode);
    }

    public static void removeCustomFetchParam(String key) {
        removeCustomFetchParam(key, "", "");
    }

    public static void removeCustomFetchParam(String key, String appId, String tempCode) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        if (instance == null) return;
        instance.removeCustomFetchParams(key, tempCode);
    }

    public static TDObject getData() {
        return getData("", "");
    }

    public static TDObject getData(String appId, String tempCode) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
        Pair<JSONObject, JSONObject> pair = null;
        if (instance != null) {
            pair = instance.getAll(tempCode);
        }
        return new TDObject(pair);
    }

    public static void fetch() {
        fetch("", "");
    }

    public static void fetch(String appId, String tempCode) {
        RemoteTaskManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                TDRemoteInstance instance = TDRemoteInstance.getInstance(appId);
                if (instance != null) {
                    instance.fetchWithTempCode(tempCode, 1, true);
                }
            }
        });
    }

    public static void addConfigFetchListener(OnConfigFetchListener listener) {
        TDRemoteInstance instance = TDRemoteInstance.getInstance("");
        if (instance == null) return;
        instance.addConfigFetchListener(listener, "");
    }

    public static String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    public interface OnConfigFetchListener {
        void onFetchSuccess(JSONObject statusData);
    }

    public static void addClientParams(JSONObject params) {
        TDClientValueManager.getInstance().addClientParams(params);
    }

    public static void removeClientParam(String key) {
        TDClientValueManager.getInstance().removeClientParam(key);
    }

    public static void accumulateNum(String key, double num) {
        TDClientValueManager.getInstance().accumulateNum(key,num);
    }

    public static Object getClientParamValueForKey(String key) {
        return TDClientValueManager.getInstance().get(key);
    }

    public static JSONObject getClientParams() {
        return TDClientValueManager.getInstance().getAllClientParams();
    }


}
